-- Suppression des tables
drop table T_EMPRUNT;
drop table T_UTILISATEUR;
drop table T_LIVRE;


-- Cration des tables utilisateur, livre et emprunt avec les cls trangres et l'auto incrment pour l'utilisateur
create table T_UTILISATEUR (
  UTIL_ID integer not null primary key,
  UTIL_NOM varchar2(100) not null,
  UTIL_PRENOM varchar2(100) not null
);

create table T_LIVRE (
  LIVR_ISBN VARCHAR2(100) not null primary key,
  LIVR_TITRE VARCHAR2(100) not null,
  LIVR_AUTEUR VARCHAR2(100) not null
);

create table T_EMPRUNT (
  UTIL_ID integer not null,
  LIVR_ISBN VARCHAR2(100) not null,
  DATE_EMP date not null, 
  RENDU int not null,
  PRIMARY KEY (UTIL_ID, LIVR_ISBN, DATE_EMP)
);

ALTER TABLE T_EMPRUNT
	ADD CONSTRAINT FK_TEMPRUNT_TUTILISATEUR
	FOREIGN KEY (UTIL_ID)
	REFERENCES T_UTILISATEUR (UTIL_ID);
 
ALTER TABLE T_EMPRUNT
	ADD CONSTRAINT FK_TEMPRUNT_TLIVRE
	FOREIGN KEY (LIVR_ISBN)
	REFERENCES T_LIVRE (LIVR_ISBN);



--  placer  la fin de votre script de cration de schma BD permet de gnrer automatiquement l'id d'un nouvel utilisateur (quivalent ORACLE du AUTO_INCREMENT de MySQL)

CREATE SEQUENCE SEQ_UTIL
START WITH 1;

CREATE OR REPLACE TRIGGER tbi_utilisateur
BEFORE INSERT ON T_UTILISATEUR FOR EACH ROW
DECLARE
   idUtil T_UTILISATEUR.UTIL_ID%type;
BEGIN
   SELECT SEQ_UTIL.nextval INTO idUtil FROM dual;
   :new.UTIL_ID := idUtil;
END;
